/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.uddi.api_v2.uddi_org;

import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.ws.listener.uddi.api_v2.uddi_org.CategoryBag;
import filenet.ws.listener.uddi.api_v2.uddi_org.Description;
import filenet.ws.listener.uddi.api_v2.uddi_org.IdentifierBag;
import filenet.ws.listener.uddi.api_v2.uddi_org.KeyedReference;
import filenet.ws.listener.uddi.api_v2.uddi_org.Name;
import filenet.ws.listener.uddi.api_v2.uddi_org.OverviewDoc;
import filenet.ws.listener.uddi.api_v2.uddi_org.TModelKey;
import filenet.ws.listener.uddi.inquiry_v2.uddi_org.WSWorkflowServiceInfo;
import filenet.ws.utils.WSConstants;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.axis.description.AttributeDesc;
import org.apache.axis.description.ElementDesc;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.encoding.Deserializer;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.encoding.ser.BeanDeserializer;
import org.apache.axis.encoding.ser.BeanSerializer;
import org.w3c.dom.Element;

public class TModel
implements Serializable {
    private static final long serialVersionUID = 464L;
    protected Element baseElement = null;
    protected static final Logger logger = Logger.getLogger("filenet.ws.listener.uddi");
    protected static final String m_className = "TModel";
    private Name name = null;
    private Description[] description = null;
    private OverviewDoc overviewDoc = null;
    private IdentifierBag identifierBag = null;
    private CategoryBag categoryBag = null;
    private TModelKey tModelKey = null;
    private String operator = null;
    private String authorizedName = null;
    private static CategoryBag tModelCategoryBag = null;
    private static Description[] overviewDocDescription = null;
    private static DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1);
    public static KeyedReference wsdlSpecKeyedReference = new KeyedReference();
    private Object __equalsCalc = null;
    private boolean __hashCodeCalc = false;
    private static TypeDesc typeDesc;

    public static String _get_FILE_DATE() {
        return "$Date:   29 Jun 2007 01:46:18  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.8  $";
    }

    public static String genTModelKeyString(WSWorkflowServiceInfo serviceInfo) {
        if (serviceInfo.getVersionAgnostic()) {
            return "tM:" + serviceInfo.getIsolatedRegion() + ":" + serviceInfo.getName() + ":" + serviceInfo.getWorkspaceId();
        }
        return "tM:" + serviceInfo.getIsolatedRegion() + ":" + serviceInfo.getName();
    }

    public static String genTModelDescription(WSWorkflowServiceInfo serviceInfo) {
        Date date;
        String descrip = serviceInfo.getDescription();
        if (descrip != null && (descrip = descrip.trim()).length() == 0) {
            descrip = serviceInfo.getName().trim();
        }
        if ((date = serviceInfo.getTransferDateTime()) != null) {
            descrip = descrip + "\n" + dateFormat.format(date);
        }
        return descrip;
    }

    public TModel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TModel(WSWorkflowServiceInfo serviceInfo) throws VWException {
        String m_method = "Ctor";
        logger.entering(m_className, m_method);
        try {
            this.name = new Name(serviceInfo.getName());
            this.description = new Description[1];
            this.description[0] = new Description(TModel.genTModelDescription(serviceInfo));
            this.tModelKey = new TModelKey(TModel.genTModelKeyString(serviceInfo));
            this.overviewDoc = new OverviewDoc();
            this.overviewDoc.setDescription(overviewDocDescription);
            this.overviewDoc.setOverviewURL(this.getWSDLURL(serviceInfo));
            this.categoryBag = tModelCategoryBag;
            this.operator = serviceInfo.getOperator();
            this.authorizedName = serviceInfo.getAuthorizedName();
        }
        catch (VWException ex) {
            logger.throwing(m_className, m_method, ex);
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    private String getWSDLURL(WSWorkflowServiceInfo serviceInfo) throws VWException {
        String m_method = "getWSDLURL";
        try {
            logger.entering(m_className, m_method);
            StringBuffer buf = new StringBuffer();
            String baseURL = serviceInfo.getBaseURL();
            if (baseURL.endsWith("/")) {
                baseURL = baseURL.substring(0, baseURL.length() - 1);
            }
            buf.append(baseURL);
            String cpName = serviceInfo.getConnectionPointName();
            if (cpName != null && cpName.length() > 0) {
                buf.append("/wscp").append(WSConstants.UTF8Encode(cpName));
            }
            buf.append("/wc/").append(WSConstants.UTF8Encode(serviceInfo.getName()));
            if (!serviceInfo.getVersionAgnostic()) {
                buf.append("/").append(serviceInfo.getWorkspaceId());
            }
            buf.append("?wsdl");
            String WSDLLink = buf.toString();
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, WSDLLink);
            }
            String string = WSDLLink;
            return string;
        }
        catch (Exception e) {
            throw new VWException(e);
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public Description[] getDescription() {
        return this.description;
    }

    public void setDescription(Description[] description) {
        this.description = description;
    }

    public Description getDescription(int i) {
        return this.description[i];
    }

    public void setDescription(int i, Description value) {
        this.description[i] = value;
    }

    public OverviewDoc getOverviewDoc() {
        return this.overviewDoc;
    }

    public void setOverviewDoc(OverviewDoc overviewDoc) {
        this.overviewDoc = overviewDoc;
    }

    public IdentifierBag getIdentifierBag() {
        return this.identifierBag;
    }

    public void setIdentifierBag(IdentifierBag identifierBag) {
        this.identifierBag = identifierBag;
    }

    public CategoryBag getCategoryBag() {
        return this.categoryBag;
    }

    public void setCategoryBag(CategoryBag categoryBag) {
        this.categoryBag = categoryBag;
    }

    public TModelKey getTModelKey() {
        return this.tModelKey;
    }

    public void setTModelKey(TModelKey tModelKey) {
        this.tModelKey = tModelKey;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getAuthorizedName() {
        return this.authorizedName;
    }

    public void setAuthorizedName(String authorizedName) {
        this.authorizedName = authorizedName;
    }

    public synchronized boolean equals(Object obj) {
        if (!(obj instanceof TModel)) {
            return false;
        }
        TModel other = (TModel)obj;
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.__equalsCalc != null) {
            return this.__equalsCalc == obj;
        }
        this.__equalsCalc = obj;
        boolean _equals = (this.name == null && other.getName() == null || this.name != null && this.name.equals(other.getName())) && (this.description == null && other.getDescription() == null || this.description != null && Arrays.equals(this.description, other.getDescription())) && (this.overviewDoc == null && other.getOverviewDoc() == null || this.overviewDoc != null && this.overviewDoc.equals(other.getOverviewDoc())) && (this.identifierBag == null && other.getIdentifierBag() == null || this.identifierBag != null && this.identifierBag.equals(other.getIdentifierBag())) && (this.categoryBag == null && other.getCategoryBag() == null || this.categoryBag != null && this.categoryBag.equals(other.getCategoryBag())) && (this.tModelKey == null && other.getTModelKey() == null || this.tModelKey != null && this.tModelKey.equals(other.getTModelKey())) && (this.operator == null && other.getOperator() == null || this.operator != null && this.operator.equals(other.getOperator())) && (this.authorizedName == null && other.getAuthorizedName() == null || this.authorizedName != null && this.authorizedName.equals(other.getAuthorizedName()));
        this.__equalsCalc = null;
        return _equals;
    }

    public synchronized int hashCode() {
        if (this.__hashCodeCalc) {
            return 0;
        }
        this.__hashCodeCalc = true;
        int _hashCode = 1;
        if (this.getName() != null) {
            _hashCode += this.getName().hashCode();
        }
        if (this.getDescription() != null) {
            for (int i = 0; i < Array.getLength(this.getDescription()); ++i) {
                Object obj = Array.get(this.getDescription(), i);
                if (obj == null || obj.getClass().isArray()) continue;
                _hashCode += obj.hashCode();
            }
        }
        if (this.getOverviewDoc() != null) {
            _hashCode += this.getOverviewDoc().hashCode();
        }
        if (this.getIdentifierBag() != null) {
            _hashCode += this.getIdentifierBag().hashCode();
        }
        if (this.getCategoryBag() != null) {
            _hashCode += this.getCategoryBag().hashCode();
        }
        if (this.getTModelKey() != null) {
            _hashCode += this.getTModelKey().hashCode();
        }
        if (this.getOperator() != null) {
            _hashCode += this.getOperator().hashCode();
        }
        if (this.getAuthorizedName() != null) {
            _hashCode += this.getAuthorizedName().hashCode();
        }
        this.__hashCodeCalc = false;
        return _hashCode;
    }

    public static TypeDesc getTypeDesc() {
        return typeDesc;
    }

    public static Serializer getSerializer(String mechType, Class _javaType, QName _xmlType) {
        return new BeanSerializer(_javaType, _xmlType, typeDesc);
    }

    public static Deserializer getDeserializer(String mechType, Class _javaType, QName _xmlType) {
        return new BeanDeserializer(_javaType, _xmlType, typeDesc);
    }

    public void saveToXML(Element parent) {
        this.baseElement = parent.getOwnerDocument().createElement("tModel");
        if (this.tModelKey != null) {
            this.baseElement.setAttribute("tModelKey", this.tModelKey.getValue());
        }
        if (this.operator != null) {
            this.baseElement.setAttribute("operator", this.operator);
        }
        if (this.authorizedName != null) {
            this.baseElement.setAttribute("authorizedName", this.authorizedName);
        }
        if (this.name != null) {
            this.name.setLang(null);
            this.name.saveToXML(this.baseElement);
        }
        if (this.description != null && this.description.length > 0) {
            for (int i = 0; i < this.description.length; ++i) {
                if (this.description[i] == null) continue;
                this.description[i].saveToXML(this.baseElement);
            }
        }
        if (this.overviewDoc != null) {
            this.overviewDoc.saveToXML(this.baseElement);
        }
        if (this.identifierBag != null) {
            this.identifierBag.saveToXML(this.baseElement);
        }
        if (this.categoryBag != null) {
            this.categoryBag.saveToXML(this.baseElement);
        }
        parent.appendChild(this.baseElement);
    }

    static {
        wsdlSpecKeyedReference.setKeyName("uddi-org:types");
        wsdlSpecKeyedReference.setKeyValue("wsdlSpec");
        wsdlSpecKeyedReference.setTModelKey(new TModelKey("UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4"));
        tModelCategoryBag = new CategoryBag();
        KeyedReference[] kr = new KeyedReference[]{wsdlSpecKeyedReference};
        tModelCategoryBag.setKeyedReference(kr);
        overviewDocDescription = new Description[1];
        TModel.overviewDocDescription[0] = new Description("WSDL link");
        typeDesc = new TypeDesc(TModel.class);
        typeDesc.setXmlType(new QName("urn:uddi-org:api_v2", "tModel"));
        AttributeDesc attrField = new AttributeDesc();
        attrField.setFieldName("TModelKey");
        attrField.setXmlName(new QName("", "tModelKey"));
        attrField.setXmlType(new QName("urn:uddi-org:api_v2", "tModelKey"));
        typeDesc.addFieldDesc((FieldDesc)attrField);
        attrField = new AttributeDesc();
        attrField.setFieldName("operator");
        attrField.setXmlName(new QName("", "operator"));
        attrField.setXmlType(new QName("http://www.w3.org/2001/XMLSchema", "string"));
        typeDesc.addFieldDesc((FieldDesc)attrField);
        attrField = new AttributeDesc();
        attrField.setFieldName("authorizedName");
        attrField.setXmlName(new QName("", "authorizedName"));
        attrField.setXmlType(new QName("http://www.w3.org/2001/XMLSchema", "string"));
        typeDesc.addFieldDesc((FieldDesc)attrField);
        ElementDesc elemField = new ElementDesc();
        elemField.setFieldName("name");
        elemField.setXmlName(new QName("urn:uddi-org:api_v2", "name"));
        elemField.setXmlType(new QName("urn:uddi-org:api_v2", "name"));
        typeDesc.addFieldDesc((FieldDesc)elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("description");
        elemField.setXmlName(new QName("urn:uddi-org:api_v2", "description"));
        elemField.setXmlType(new QName("urn:uddi-org:api_v2", "description"));
        elemField.setMinOccurs(0);
        typeDesc.addFieldDesc((FieldDesc)elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("overviewDoc");
        elemField.setXmlName(new QName("urn:uddi-org:api_v2", "overviewDoc"));
        elemField.setXmlType(new QName("urn:uddi-org:api_v2", "overviewDoc"));
        elemField.setMinOccurs(0);
        typeDesc.addFieldDesc((FieldDesc)elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("identifierBag");
        elemField.setXmlName(new QName("urn:uddi-org:api_v2", "identifierBag"));
        elemField.setXmlType(new QName("urn:uddi-org:api_v2", "identifierBag"));
        elemField.setMinOccurs(0);
        typeDesc.addFieldDesc((FieldDesc)elemField);
        elemField = new ElementDesc();
        elemField.setFieldName("categoryBag");
        elemField.setXmlName(new QName("urn:uddi-org:api_v2", "categoryBag"));
        elemField.setXmlType(new QName("urn:uddi-org:api_v2", "categoryBag"));
        elemField.setMinOccurs(0);
        typeDesc.addFieldDesc((FieldDesc)elemField);
    }
}

